#include <iostream>
#include <algorithm>
#include <vector>
#include <map>
#include <fstream>
using namespace std;
typedef long long ll;

vector<string> split(string s){
    vector<string> ans;
    int cnt = 0;
    int curr = 0;
    for (int j = 0; j < s.length(); j ++){
        if (s[j] == ',') {
            ans.push_back(s.substr(curr, cnt));
            cnt = 0;
            curr = j + 2;
            j ++;
        }
        else cnt ++;
    }
    if (curr != s.length()) ans.push_back(s.substr(curr, cnt));
    return ans;
}

#define maxn 505
struct person{
    int age; string country, race, sex, job;
} P[maxn];
int n, m;
vector<vector<int>> value;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    ifstream file ("adult.txt");
    string s; int cnt = 0;

    //set an id on each job for easy access
    map<string, int> job;
    int id = 0;

    //read input
    while(getline(file, s) && cnt <= 500){
        vector<string> v = split(s);
        P[cnt].age = stoi(v[0]);
        if (! job.count(v[6])) job[v[6]] = id ++;
        P[cnt].job = v[6];
        P[cnt].race = v[8];
        P[cnt].sex = v[9];
        P[cnt ++].country = v[13];
    }
    file.close();

    //Use sex items and constraint.
    n = 2, m = job.size();
    value.assign(n, vector<int>(m, 5));
    for (int i = 0; i < cnt; i ++){
        if (P[i].sex == "Male"){
            value[1][job[P[i].job]] ++;
        } else{
            value[0][job[P[i].job]] ++;
        }
    }

    //output valuation
    done: cout << '[';
    for (int i = 0; i < n; i ++){
        cout << '[';
        for (int j = 0; j < m; j ++){
            if (j != m - 1) cout << value[i][j] << ", ";
            else cout << value[i][j];
        }
        if (i != n - 1) cout << "], " << endl;
        else cout << ']';
    }
    cout << ']' << endl;
}